local assets=
{
	Asset("ANIM", "anim/mushasword4.zip"),
	Asset("ANIM", "anim/swap_mushasword4.zip"),
    	Asset("ATLAS", "images/inventoryimages/mushasword4.xml"),
	Asset("IMAGE", "images/inventoryimages/mushasword4.tex"),

}

local function onfinished(inst)
    inst:Remove()
end


local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_mushasword4", "swap_batbat")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
    local light2 = inst.entity:AddLight()
    light2:SetFalloff(.6)
    light2:SetIntensity(.6)
    light2:SetRadius(1)
    light2:Enable(true)
    light2:SetColour(255/255, 88/255, 112/255)	 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 

end


local function onattack(inst, owner, target)
    if owner.components.health and owner.components.health:GetPercent() < 1 and not target:HasTag("wall") then
        owner.components.health:DoDelta(TUNING.SPEAR_DRAIN,false,"spear")
        owner.components.sanity:DoDelta(TUNING.SPEAR_DRAIN * 0.5)
    end
end

local function onattack(inst, owner, target)
    if owner.components.health and owner.components.health:GetPercent() < 1 and not target:HasTag("wall") then
        owner.components.health:DoDelta(TUNING.BATBAT_DRAIN,false,"batbat")
        owner.components.sanity:DoDelta(-TUNING.BATBAT_DRAIN * 0.5)
    end
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("batbat")
    anim:SetBuild("mushasword4")
    anim:PlayAnimation("idle")
    
    inst:AddTag("dull")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(40)
    inst.components.weapon.onattack = onattack

    -------
    local light = inst.entity:AddLight()
    light:SetFalloff(0.5)
-- ˥ԽСԽ,0.01,0 
    light:SetIntensity(.8) 
-- ǿȣ0.99 
    light:SetRadius(1.5)
-- ȷΧֵԽΧԽ 
    light:SetColour(255/255, 88/255, 112/255) 
    light:Enable(true)



    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.SPEAR_USES*2)
    inst.components.finiteuses:SetUses(TUNING.SPEAR_USES*2)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")


    	inst.components.inventoryitem.atlasname = "images/inventoryimages/mushasword4.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    
    return inst
end

return Prefab( "common/inventory/mushasword4", fn, assets) 
